# -*- coding: utf-8 -*-
from ladon.ladonizer import ladonize
from mysite.pywebsv.utils import SUCCESS_CODE, MESSAGE_CODE, request_valid, interface_response, \
    SUPPORT_CONTACT, WEBSITE, SYSTEM_EXCEPTION
import json


class BioTimeAppSetting(object):

    """
    【Setting】设置
    """
    @request_valid
    @ladonize(int, str, str, str, rtype=str)
    def pull_setting(self, source, device_token, language, token):
        """
        获取设置
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:返回请求结果
            请求成功
                {"code": 1, "error": "", "describe":"", "message": "", "data": {"enable_capture":是否开启考勤照片(0/1), "enable_workcode":1, "enable_funckey":是否开启功能键(0/1), "contact":"邮箱地址", "website":"网址}}
            请求失败
                {"code":-10001, "error":"", "describe":"", "message":"", "data":""}
        """
        from mysite.att.models.attparam import AttParam
        try:
            vals = AttParam.objects.filter(ParaName__in=['enable_capture', 'enable_workcode', 'enable_funckey']).values('ParaName', 'ParaValue')
            setting = {
                'contact': SUPPORT_CONTACT,
                'website': WEBSITE,
            }
            for val in vals:
                setting['{0}'.format(val['ParaName'])] = '{0}'.format(val['ParaValue'])
            return interface_response(SUCCESS_CODE, json.dumps(setting), '', 'successful')
        except Exception, e:
            import traceback
            traceback.print_exc()
            return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)

    @request_valid
    @ladonize(int, int, int, int, str, str, str, rtype=str)
    def upload_setting(self, enable_capture, enable_workcode, enable_funckey, source, device_token, language, token):
        """
        上传设置
        @param enable_capture:  开启考勤照片 (0/1)
        @param enable_workcode: 开启Workcode (0/1)
        @param enable_funckey:  开启功能键   (0/1)
        @param source:          数据来源(1: IOS， 2：Android)
        @param device_token:    消息推送Token
        @param language:
        @param token:
        @rtype:返回请求结果
            请求成功
                {"code": 1, "error": "", "describe":"", "message": "", "data": ""}
            请求失败
                {"code":-10001, "error":"", "describe":"", "message":"", "data":""}
        """
        from django.utils.cache import cache
        from mysite.att.models.attparam import AttParam
        try:
            AttParam.objects.filter(ParaName='enable_capture').update(ParaValue=enable_capture)
            AttParam.objects.filter(ParaName='enable_workcode').update(ParaValue=enable_workcode)
            AttParam.objects.filter(ParaName='enable_funckey').update(ParaValue=enable_funckey)
            cache.delete('att_param')
            return interface_response(SUCCESS_CODE, '', '', 'successful')
        except Exception, e:
            import traceback
            traceback.print_exc()
            return interface_response(MESSAGE_CODE, '', '', e, SYSTEM_EXCEPTION)

